/*
 *
 *  Copyright (C) 2008-2009 RICOH Co.,LTD.
 *  All rights reserved.
 *
 *  affiliation	:DSS Development Center
 *  		 Document Solutions & Services Division
 * 
 *  purpose	: OCF applet card service sample.
 *
 */

package ocfbundle;

import opencard.core.service.CardChannel;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.applet.AppletID;
import opencard.opt.applet.AppletInfo;
import opencard.opt.applet.AppletSelector;
import opencard.opt.applet.BasicAppletCardService;
import opencard.opt.terminal.ISOCommandAPDU;

/**
 * MyAppletService class
 * This class extends BasicAppletCardService and uses a newly implemented AppletSelector.
 * 
 * MyAppletServiceクラス
 * BasicAppletCardServiceを継承し、独自のAppletSelectorを使用しています。
 */
public class MyAppletService extends BasicAppletCardService {
	
	/**
	 * Default constructor.
	 * 
	 * デフォルトコンストラクタです。
	 */
	public MyAppletService() {
		super();
		setAppletSelector(new MyAppletSelector());
	}
}

/**
 * MyAppletSelector class
 * This class implements AppletSelector.
 * 
 * MyAppletSelectorクラス
 * AppletSelectorを実装しています。
 */
class MyAppletSelector implements AppletSelector {
	
	/**
	 * Card commands.
	 * 
	 * カードコマンド。
	 */
	private final static byte CLA             = (byte)0x00;
	private final static byte INS_SELECT 	  = (byte)0xA4;
	private final static byte INS_GETRESPONSE = (byte)0xC0;
	private final static byte BZ              = (byte)0x00;
	
	/**
	 * Status words.
	 * 
	 * ステータスワード。
	 */
	private final static byte SW1_OK          = (byte) 0x90;
	private final static byte SW1_MOREDATA    = (byte) 0x61;
	
	/* (non-Javadoc)
	 * @see opencard.opt.applet.AppletSelector#selectApplet(opencard.core.service.CardChannel, opencard.opt.applet.AppletID)
	 */
	public synchronized AppletInfo selectApplet(CardChannel channel, AppletID appletID) throws CardTerminalException, CardServiceException {
		AppletInfo result = null;
		
		if (channel == null) {
			throw new CardServiceException("selectApplet: No CardChannel!");
			
		} else if ((appletID == null) || (appletID.getBytes() == null)) {
			result = new AppletInfo();
			result.setAppletID(appletID);
			result.setData(new ResponseAPDU(new byte[]{SW1_OK, BZ}));
			
		} else {
			ISOCommandAPDU req = null;
			ResponseAPDU res = null;
			
			req = new ISOCommandAPDU(
					CLA,
					INS_SELECT,
					BZ,
					BZ,
					appletID.getBytes());
			res = channel.sendCommandAPDU(req);
			
			if (res.sw1() == SW1_MOREDATA) {
				req = new ISOCommandAPDU(
						CLA,
						INS_GETRESPONSE,
						BZ,
						BZ,
						(int) res.sw2());
				res = channel.sendCommandAPDU(req);
			}
			
			result = new AppletInfo();
			result.setAppletID(appletID);
			result.setData(res);
		}
		
		return result;
	}
}
